@extends('frontend.layouts.app')
@section('content')
<x-frontend.home.banner />
<x-frontend.home.about />

<section class="destination">
    <div class="bg-layer" style="background: url({{asset('frontend/images/shape/bg-1.webp')}});">
    </div>
    <div class="container">
        <div class="common-title text-center">
            <x-title :title="__('title.popular-packages')" :desc="__('title.popular-packages-desc')" />
        </div>
        <div class="row">
            @forelse ($packages as $package)
            <x-frontend.home.package :package="$package" />
            @empty
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    @lang('app.no-package-found')
                </div>
            </div>
            @endforelse
        </div>
    </div>
</section>

<section class="popular">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <x-title :title="__('title.destination')" :desc="__('title.destination-desc')" />
            </div>
            @forelse ($destinations as $destination)
            <x-frontend.home.destination :destination="$destination" />
            @empty
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    @lang('app.no-destination-found')
                </div>
            </div>
            @endforelse
        </div>
    </div>
</section>

<x-frontend.home.inspiration />
{{--
<x-frontend.home.app-download /> --}}
<x-frontend.home.testimonial />
<section class="blog">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <x-title :title="__('title.blog')" :desc="__('title.blog-desc')" />
            </div>
        </div>
        <div class="row">
            @forelse ($blogs as $blog)
            <x-frontend.home.blog :blog="$blog" />
            @empty
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    No Blog found!
                </div>
            </div>
            @endforelse
        </div>
    </div>
</section>

<x-frontend.home.newsletter />
@endsection
